#include <TFT_eSPI.h>
#include <CST816S.h>
#include "Free_Fonts.h"
#include <Wire.h>

TFT_eSPI tft = TFT_eSPI();
CST816S touch(5, 6, 10, 7);

unsigned long callStartTime = 0;
bool isCallActive = false;

void setup() {
  Serial.begin(115200);

  pinMode(TFT_BL, OUTPUT);
  digitalWrite(TFT_BL, HIGH);

  tft.begin();
  tft.fillScreen(TFT_BLACK);
  tft.setTextColor(TFT_WHITE, TFT_BLACK);
  tft.setFreeFont(FSB9);

  drawMiddleText();
  drawButtons();
  touch.begin();
}

void drawMiddleText() {
  tft.setCursor(30, 50);
  tft.setTextColor(TFT_GREEN, TFT_BLACK);
  tft.print("Calling 7061350809");
}

void drawButtons() {
  int buttonRadius = 30;

  // Draw Call Button
  int callButtonX = 80;
  int callButtonY = 180; // Moved up
  tft.fillCircle(callButtonX, callButtonY, buttonRadius, TFT_GREEN);
  tft.setTextColor(TFT_WHITE, TFT_GREEN);
  tft.setCursor(callButtonX - 15, callButtonY - 7); // Center text inside the circle
  tft.print("Call");

  // Draw End Button
  int endButtonX = 160;
  int endButtonY = 180; // Moved up
  tft.fillCircle(endButtonX, endButtonY, buttonRadius, TFT_RED);
  tft.setTextColor(TFT_WHITE, TFT_RED);
  tft.setCursor(endButtonX - 15, endButtonY - 7); // Center text inside the circle
  tft.print("End");
}

void loop() {
  if (touch.available()) {
    int x = touch.data.x;
    int y = touch.data.y;

    if (isCallButtonTouched(x, y)) {
      Serial.println("Call button pressed");
      startCall();
    }

    if (isEndButtonTouched(x, y) && isCallActive) {
      Serial.println("End button pressed");
      endCall();
    }
  }

  if (isCallActive) {
    updateCallTimer();
  }
}

bool isCallButtonTouched(int x, int y) {
  int buttonRadius = 30;
  int buttonX = 80;
  int buttonY = 180; // Same as callButtonY in drawButtons

  int dx = x - buttonX;
  int dy = y - buttonY;
  return (dx * dx + dy * dy <= buttonRadius * buttonRadius);
}

bool isEndButtonTouched(int x, int y) {
  int buttonRadius = 30;
  int buttonX = 160;
  int buttonY = 180; // Same as endButtonY in drawButtons

  int dx = x - buttonX;
  int dy = y - buttonY;
  return (dx * dx + dy * dy <= buttonRadius * buttonRadius);
}

void startCall() {
  isCallActive = true;
  callStartTime = millis();
  tft.fillScreen(TFT_BLACK); // Clear the screen
  tft.setCursor(30, 50);
  tft.setTextColor(TFT_GREEN, TFT_BLACK);
  tft.print("Call in progress...");
}

void endCall() {
  isCallActive = false;
  tft.fillScreen(TFT_BLACK);
  tft.setCursor(30, 50);
  tft.setTextColor(TFT_RED, TFT_BLACK);
  tft.print("Call Ended.");
  drawButtons();
}

void updateCallTimer() {
  unsigned long elapsedTime = millis() - callStartTime;
  unsigned int seconds = (elapsedTime / 1000) % 60;
  unsigned int minutes = (elapsedTime / 60000) % 60;
  unsigned int hours = (elapsedTime / 3600000);

  // Format time as HH:MM:SS
  char timeString[9];
  sprintf(timeString, "%02d:%02d:%02d", hours, minutes, seconds);

  tft.setCursor(30, 100);
  tft.setTextColor(TFT_GREEN, TFT_BLACK);
  tft.fillRect(30, 100, 200, 20, TFT_BLACK); // Clear the old time
  tft.print(timeString);
}
